/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.impl.FastRunningAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.AdditionalProperties;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FastRun
extends Action {
    private static final String FAST_RUNNING_MODIFIER_NAME = "parcool.modifier.fastrunnning";
    private static final UUID FAST_RUNNING_MODIFIER_UUID = UUID.randomUUID();
    private double speedModifier = 0.0;

    @Override
    public void onServerTick(Player player, Parkourability parkourability, IStamina stamina) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
        if (attr == null) {
            return;
        }
        if (attr.m_22111_(FAST_RUNNING_MODIFIER_UUID) != null) {
            attr.m_22120_(FAST_RUNNING_MODIFIER_UUID);
        }
        if (this.isDoing()) {
            player.m_6858_(true);
            attr.m_22118_(new AttributeModifier(FAST_RUNNING_MODIFIER_UUID, FAST_RUNNING_MODIFIER_NAME, this.speedModifier / 100.0, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        startInfo.putDouble((Double)ParCoolConfig.CONFIG_CLIENT.fastRunningModifier.get());
        return this.canContinue(player, parkourability, stamina);
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return parkourability.getActionInfo().can(FastRun.class) && !stamina.isExhausted() && player.m_20142_() && !player.m_20143_() && !player.m_6069_() && !parkourability.get(Crawl.class).isDoing() && (KeyBindings.getKeyFastRunning().m_90857_() || (Boolean)ParCoolConfig.CONFIG_CLIENT.replaceSprintWithFastRun.get() != false);
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new FastRunningAnimator());
        }
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new FastRunningAnimator());
        }
    }

    @Override
    public void onStartInServer(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.speedModifier = startData.getDouble();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canActWithRunning(Player player) {
        return (Boolean)ParCoolConfig.CONFIG_CLIENT.substituteSprintForFastRun.get() != false ? player.m_20142_() : this.isDoing();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDashTick(AdditionalProperties properties) {
        return (Boolean)ParCoolConfig.CONFIG_CLIENT.substituteSprintForFastRun.get() != false ? properties.getSprintingTick() : this.getDoingTick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getNotDashTick(AdditionalProperties properties) {
        return (Boolean)ParCoolConfig.CONFIG_CLIENT.substituteSprintForFastRun.get() != false ? properties.getNotSprintingTick() : this.getNotDoingTick();
    }
}

